package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VmotivosSubsanacionExpOs3;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VmotivosSubsanacionExpOs3DaoImpl generated by UDA, 08-jun-2017 15:49:25.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VmotivosSubsanacionExpOs3DaoImpl implements
		VmotivosSubsanacionExpOs3Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VmotivosSubsanacionExpOs3> rwMap = new RowMapper<VmotivosSubsanacionExpOs3>() {
		public VmotivosSubsanacionExpOs3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VmotivosSubsanacionExpOs3(resultSet.getString("TEROS"),
					resultSet.getString("ANOOS"), resultSet.getInt("NUMOS"),
					resultSet.getLong("IDTRAMITE"),
					resultSet.getLong("TIPOTRAMITE"),
					resultSet.getLong("IDTAREA"),
					resultSet.getLong("TIPOTAREA"),
					resultSet.getString("CODMOTIVO"),
					resultSet.getString("DESCRIPCIONES"),
					resultSet.getString("DESCRIPCIONEUS"),
					resultSet.getString("DESCOTROSES"),
					resultSet.getString("DESCOTROSEU"));
		}
	};

	private RowMapper<VmotivosSubsanacionExpOs3> rwMapPK = new RowMapper<VmotivosSubsanacionExpOs3>() {
		public VmotivosSubsanacionExpOs3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VmotivosSubsanacionExpOs3(resultSet.getString("TEROS"),
					resultSet.getString("ANOOS"), resultSet.getInt("NUMOS"),
					resultSet.getLong("IDTRAMITE"),
					resultSet.getLong("TIPOTRAMITE"),
					resultSet.getLong("IDTAREA"),
					resultSet.getLong("TIPOTAREA"),
					resultSet.getString("CODMOTIVO"),
					resultSet.getString("DESCRIPCIONES"),
					resultSet.getString("DESCRIPCIONEUS"),
					resultSet.getString("DESCOTROSES"),
					resultSet.getString("DESCOTROSEU"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VmotivosSubsanacionExpOs3 table.
	 * 
	 *  vmotivossubsanacionexpos3
	 *            VmotivosSubsanacionExpOs3
	 *  VmotivosSubsanacionExpOs3
	 *
	 * @param vmotivossubsanacionexpos3 the vmotivossubsanacionexpos 3
	 * @return the vmotivos subsanacion exp os 3
	 */
	public VmotivosSubsanacionExpOs3 add(
			VmotivosSubsanacionExpOs3 vmotivossubsanacionexpos3) {
		String query = "INSERT INTO VMOTIVOS_SUBSANACION_EXP_OS3 (TEROS, ANOOS, NUMOS, ID_TRAMITE, TIPO_TRAMITE, ID_TAREA, TIPO_TAREA, CODMOTIVO, DESCRIPCION_ES, DESCRIPCION_EUS, DESC_OTROS_ES, DESC_OTROS_EU) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, vmotivossubsanacionexpos3.getTeros(),
				vmotivossubsanacionexpos3.getAnoos(),
				vmotivossubsanacionexpos3.getNumos(),
				vmotivossubsanacionexpos3.getIdTramite(),
				vmotivossubsanacionexpos3.getTipoTramite(),
				vmotivossubsanacionexpos3.getIdTarea(),
				vmotivossubsanacionexpos3.getTipoTarea(),
				vmotivossubsanacionexpos3.getCodmotivo(),
				vmotivossubsanacionexpos3.getDescripcionEs(),
				vmotivossubsanacionexpos3.getDescripcionEus(),
				vmotivossubsanacionexpos3.getDescOtrosEs(),
				vmotivossubsanacionexpos3.getDescOtrosEu());
		return vmotivossubsanacionexpos3;
	}

	/**
	 * Updates a single row in the VmotivosSubsanacionExpOs3 table.
	 * 
	 *  vmotivossubsanacionexpos3
	 *            VmotivosSubsanacionExpOs3
	 *  VmotivosSubsanacionExpOs3
	 *
	 * @param vmotivossubsanacionexpos3 the vmotivossubsanacionexpos 3
	 * @return the vmotivos subsanacion exp os 3
	 */
	public VmotivosSubsanacionExpOs3 update(
			VmotivosSubsanacionExpOs3 vmotivossubsanacionexpos3) {
		String query = "UPDATE VMOTIVOS_SUBSANACION_EXP_OS3 SET  WHERE TEROS=? AND ANOOS=? AND NUMOS=? AND ID_TRAMITE=? AND TIPO_TRAMITE=? AND ID_TAREA=? AND TIPO_TAREA=? AND CODMOTIVO=? AND DESCRIPCION_ES=? AND DESCRIPCION_EUS=? AND DESC_OTROS_ES=? AND DESC_OTROS_EU=?";
		this.jdbcTemplate.update(query, vmotivossubsanacionexpos3.getTeros(),
				vmotivossubsanacionexpos3.getAnoos(),
				vmotivossubsanacionexpos3.getNumos(),
				vmotivossubsanacionexpos3.getIdTramite(),
				vmotivossubsanacionexpos3.getTipoTramite(),
				vmotivossubsanacionexpos3.getIdTarea(),
				vmotivossubsanacionexpos3.getTipoTarea(),
				vmotivossubsanacionexpos3.getCodmotivo(),
				vmotivossubsanacionexpos3.getDescripcionEs(),
				vmotivossubsanacionexpos3.getDescripcionEus(),
				vmotivossubsanacionexpos3.getDescOtrosEs(),
				vmotivossubsanacionexpos3.getDescOtrosEu());
		return vmotivossubsanacionexpos3;
	}

	/**
	 * Finds a single row in the VmotivosSubsanacionExpOs3 table.
	 * 
	 *  vmotivossubsanacionexpos3
	 *            VmotivosSubsanacionExpOs3
	 *  VmotivosSubsanacionExpOs3
	 *
	 * @param vmotivossubsanacionexpos3 the vmotivossubsanacionexpos 3
	 * @return the vmotivos subsanacion exp os 3
	 */
	@Transactional(readOnly = true)
	public VmotivosSubsanacionExpOs3 find(
			VmotivosSubsanacionExpOs3 vmotivossubsanacionexpos3) {
		String query = "SELECT t1.TEROS TEROS, t1.ANOOS ANOOS, t1.NUMOS NUMOS, t1.ID_TRAMITE IDTRAMITE, t1.TIPO_TRAMITE TIPOTRAMITE, t1.ID_TAREA IDTAREA, t1.TIPO_TAREA TIPOTAREA, t1.CODMOTIVO CODMOTIVO, t1.DESCRIPCION_ES DESCRIPCIONES, t1.DESCRIPCION_EUS DESCRIPCIONEUS, t1.DESC_OTROS_ES DESCOTROSES, t1.DESC_OTROS_EU DESCOTROSEU FROM VMOTIVOS_SUBSANACION_EXP_OS3 t1  WHERE t1.TEROS = ?   AND t1.ANOOS = ?   AND t1.NUMOS = ?   AND t1.ID_TRAMITE = ?   AND t1.TIPO_TRAMITE = ?   AND t1.ID_TAREA = ?   AND t1.TIPO_TAREA = ?   AND t1.CODMOTIVO = ?   AND t1.DESCRIPCION_ES = ?   AND t1.DESCRIPCION_EUS = ?   AND t1.DESC_OTROS_ES = ?   AND t1.DESC_OTROS_EU = ?  ";

		List<VmotivosSubsanacionExpOs3> vmotivossubsanacionexpos3List = this.jdbcTemplate
				.query(query, this.rwMap, vmotivossubsanacionexpos3.getTeros(),
						vmotivossubsanacionexpos3.getAnoos(),
						vmotivossubsanacionexpos3.getNumos(),
						vmotivossubsanacionexpos3.getIdTramite(),
						vmotivossubsanacionexpos3.getTipoTramite(),
						vmotivossubsanacionexpos3.getIdTarea(),
						vmotivossubsanacionexpos3.getTipoTarea(),
						vmotivossubsanacionexpos3.getCodmotivo(),
						vmotivossubsanacionexpos3.getDescripcionEs(),
						vmotivossubsanacionexpos3.getDescripcionEus(),
						vmotivossubsanacionexpos3.getDescOtrosEs(),
						vmotivossubsanacionexpos3.getDescOtrosEu());
		return (VmotivosSubsanacionExpOs3) DataAccessUtils
				.uniqueResult(vmotivossubsanacionexpos3List);
	}

	/**
	 * Removes a single row in the VmotivosSubsanacionExpOs3 table.
	 * 
	 *  vmotivossubsanacionexpos3            VmotivosSubsanacionExpOs3
	 *
	 * @param vmotivossubsanacionexpos3 the vmotivossubsanacionexpos 3
	 */
	public void remove(VmotivosSubsanacionExpOs3 vmotivossubsanacionexpos3) {
		String query = "DELETE FROM VMOTIVOS_SUBSANACION_EXP_OS3 WHERE TEROS=? AND ANOOS=? AND NUMOS=? AND ID_TRAMITE=? AND TIPO_TRAMITE=? AND ID_TAREA=? AND TIPO_TAREA=? AND CODMOTIVO=? AND DESCRIPCION_ES=? AND DESCRIPCION_EUS=? AND DESC_OTROS_ES=? AND DESC_OTROS_EU=?";
		this.jdbcTemplate.update(query, vmotivossubsanacionexpos3.getTeros(),
				vmotivossubsanacionexpos3.getAnoos(),
				vmotivossubsanacionexpos3.getNumos(),
				vmotivossubsanacionexpos3.getIdTramite(),
				vmotivossubsanacionexpos3.getTipoTramite(),
				vmotivossubsanacionexpos3.getIdTarea(),
				vmotivossubsanacionexpos3.getTipoTarea(),
				vmotivossubsanacionexpos3.getCodmotivo(),
				vmotivossubsanacionexpos3.getDescripcionEs(),
				vmotivossubsanacionexpos3.getDescripcionEus(),
				vmotivossubsanacionexpos3.getDescOtrosEs(),
				vmotivossubsanacionexpos3.getDescOtrosEu());
	}

	/**
	 * Finds a list of rows in the VmotivosSubsanacionExpOs3 table.
	 * 
	 *  vmotivossubsanacionexpos3
	 *            VmotivosSubsanacionExpOs3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VmotivosSubsanacionExpOs3>
	 *
	 * @param vmotivossubsanacionexpos3 the vmotivossubsanacionexpos 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VmotivosSubsanacionExpOs3> findAll(
			VmotivosSubsanacionExpOs3 vmotivossubsanacionexpos3,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU ");
		query.append("FROM VMOTIVOS_SUBSANACION_EXP_OS3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vmotivossubsanacionexpos3);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VmotivosSubsanacionExpOs3>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VmotivosSubsanacionExpOs3 table using like.
	 * 
	 *  vmotivossubsanacionexpos3
	 *            VmotivosSubsanacionExpOs3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VmotivosSubsanacionExpOs3>
	 *
	 * @param vmotivossubsanacionexpos3 the vmotivossubsanacionexpos 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VmotivosSubsanacionExpOs3> findAllLike(
			VmotivosSubsanacionExpOs3 vmotivossubsanacionexpos3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU ");
		query.append("FROM VMOTIVOS_SUBSANACION_EXP_OS3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				vmotivossubsanacionexpos3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VmotivosSubsanacionExpOs3>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VmotivosSubsanacionExpOs3 table.
	 * 
	 *  vmotivossubsanacionexpos3
	 *            VmotivosSubsanacionExpOs3
	 *  Long
	 *
	 * @param vmotivossubsanacionexpos3 the vmotivossubsanacionexpos 3
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VmotivosSubsanacionExpOs3 vmotivossubsanacionexpos3) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VMOTIVOS_SUBSANACION_EXP_OS3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vmotivossubsanacionexpos3);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VmotivosSubsanacionExpOs3 table using like.
	 * 
	 *  vmotivossubsanacionexpos3
	 *            VmotivosSubsanacionExpOs3
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param vmotivossubsanacionexpos3 the vmotivossubsanacionexpos 3
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(
			VmotivosSubsanacionExpOs3 vmotivossubsanacionexpos3,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VMOTIVOS_SUBSANACION_EXP_OS3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				vmotivossubsanacionexpos3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VmotivosSubsanacionExpOs3 selected for rup_table.
	 * 
	 *  vmotivossubsanacionexpos3            VmotivosSubsanacionExpOs3
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VmotivosSubsanacionExpOs3>>
	 *
	 * @param vmotivossubsanacionexpos3 the vmotivossubsanacionexpos 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VmotivosSubsanacionExpOs3>> reorderSelection(
			VmotivosSubsanacionExpOs3 vmotivossubsanacionexpos3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU ");
		// FROM
		query.append("FROM VMOTIVOS_SUBSANACION_EXP_OS3 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				vmotivossubsanacionexpos3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(
						query,
						jqGridRequestDto,
						VmotivosSubsanacionExpOs3.class,
						filterParamList,
						"TEROS,ANOOS,NUMOS,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VmotivosSubsanacionExpOs3>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            VmotivosSubsanacionExpOs3
	 *  searchParams            VmotivosSubsanacionExpOs3
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VmotivosSubsanacionExpOs3>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VmotivosSubsanacionExpOs3>> search(
			VmotivosSubsanacionExpOs3 filterParams,
			VmotivosSubsanacionExpOs3 searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU ");
		// FROM
		query.append("FROM VMOTIVOS_SUBSANACION_EXP_OS3 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(
						query,
						jqGridRequestDto,
						VmotivosSubsanacionExpOs3.class,
						filterParamList,
						searchSQL,
						searchParamList,
						from_alias,
						"TEROS,ANOOS,NUMOS,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VmotivosSubsanacionExpOs3>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filtervmotivossubsanacionexpos3            VmotivosSubsanacionExpOs3
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filtervmotivossubsanacionexpos3 the filtervmotivossubsanacionexpos 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(
			VmotivosSubsanacionExpOs3 filtervmotivossubsanacionexpos3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU ");
		// FROM
		query.append("FROM VMOTIVOS_SUBSANACION_EXP_OS3 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(
				filtervmotivossubsanacionexpos3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(
						jqGridRequestDto,
						VmotivosSubsanacionExpOs3.class,
						query,
						params,
						"TEROS,ANOOS,NUMOS,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VmotivosSubsanacionExpOs3 entity.
	 * 
	 *  vmotivossubsanacionexpos3            VmotivosSubsanacionExpOs3 Bean with the criteria values to
	 *            filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vmotivossubsanacionexpos3 the vmotivossubsanacionexpos 3
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			VmotivosSubsanacionExpOs3 vmotivossubsanacionexpos3) {

		StringBuilder where = new StringBuilder(
				VmotivosSubsanacionExpOs3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getTeros() != null) {
			where.append(" AND t1.TEROS = ?");
			params.add(vmotivossubsanacionexpos3.getTeros());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getAnoos() != null) {
			where.append(" AND t1.ANOOS = ?");
			params.add(vmotivossubsanacionexpos3.getAnoos());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getNumos() != null) {
			where.append(" AND t1.NUMOS = ?");
			params.add(vmotivossubsanacionexpos3.getNumos());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getIdTramite() != null) {
			where.append(" AND t1.ID_TRAMITE = ?");
			params.add(vmotivossubsanacionexpos3.getIdTramite());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getTipoTramite() != null) {
			where.append(" AND t1.TIPO_TRAMITE = ?");
			params.add(vmotivossubsanacionexpos3.getTipoTramite());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getIdTarea() != null) {
			where.append(" AND t1.ID_TAREA = ?");
			params.add(vmotivossubsanacionexpos3.getIdTarea());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getTipoTarea() != null) {
			where.append(" AND t1.TIPO_TAREA = ?");
			params.add(vmotivossubsanacionexpos3.getTipoTarea());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getCodmotivo() != null) {
			where.append(" AND t1.CODMOTIVO = ?");
			params.add(vmotivossubsanacionexpos3.getCodmotivo());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getDescripcionEs() != null) {
			where.append(" AND t1.DESCRIPCION_ES = ?");
			params.add(vmotivossubsanacionexpos3.getDescripcionEs());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getDescripcionEus() != null) {
			where.append(" AND t1.DESCRIPCION_EUS = ?");
			params.add(vmotivossubsanacionexpos3.getDescripcionEus());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getDescOtrosEs() != null) {
			where.append(" AND t1.DESC_OTROS_ES = ?");
			params.add(vmotivossubsanacionexpos3.getDescOtrosEs());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getDescOtrosEu() != null) {
			where.append(" AND t1.DESC_OTROS_EU = ?");
			params.add(vmotivossubsanacionexpos3.getDescOtrosEu());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VmotivosSubsanacionExpOs3 entity.
	 * 
	 *  vmotivossubsanacionexpos3            VmotivosSubsanacionExpOs3 Bean with the criteria values to
	 *            filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vmotivossubsanacionexpos3 the vmotivossubsanacionexpos 3
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(
			VmotivosSubsanacionExpOs3 vmotivossubsanacionexpos3,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VmotivosSubsanacionExpOs3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getTeros() != null) {
			where.append(" AND UPPER(t1.TEROS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos3.getTeros().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos3.getTeros().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TEROS IS NOT NULL");
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getAnoos() != null) {
			where.append(" AND UPPER(t1.ANOOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos3.getAnoos().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos3.getAnoos().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ANOOS IS NOT NULL");
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getNumos() != null) {
			where.append(" AND t1.NUMOS = ?");
			params.add(vmotivossubsanacionexpos3.getNumos());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getIdTramite() != null) {
			where.append(" AND t1.ID_TRAMITE = ?");
			params.add(vmotivossubsanacionexpos3.getIdTramite());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getTipoTramite() != null) {
			where.append(" AND t1.TIPO_TRAMITE = ?");
			params.add(vmotivossubsanacionexpos3.getTipoTramite());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getIdTarea() != null) {
			where.append(" AND t1.ID_TAREA = ?");
			params.add(vmotivossubsanacionexpos3.getIdTarea());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getTipoTarea() != null) {
			where.append(" AND t1.TIPO_TAREA = ?");
			params.add(vmotivossubsanacionexpos3.getTipoTarea());
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getCodmotivo() != null) {
			where.append(" AND UPPER(t1.CODMOTIVO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos3.getCodmotivo()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos3.getCodmotivo()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.CODMOTIVO IS NOT NULL");
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getDescripcionEs() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos3.getDescripcionEs()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos3.getDescripcionEs()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_ES IS NOT NULL");
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getDescripcionEus() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_EUS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos3.getDescripcionEus()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos3.getDescripcionEus()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_EUS IS NOT NULL");
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getDescOtrosEs() != null) {
			where.append(" AND UPPER(t1.DESC_OTROS_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos3.getDescOtrosEs()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos3.getDescOtrosEs()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_OTROS_ES IS NOT NULL");
		}
		if (vmotivossubsanacionexpos3 != null
				&& vmotivossubsanacionexpos3.getDescOtrosEu() != null) {
			where.append(" AND UPPER(t1.DESC_OTROS_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos3.getDescOtrosEu()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos3.getDescOtrosEu()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_OTROS_EU IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
